<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 191)->unique();
			$table->string('mobile', 191)->unique()->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->string('image', 191)->nullable();
			$table->string('experience', 191)->nullable();
			$table->string('jop_description', 191)->nullable();
			$table->string('birthday', 191)->nullable();
			$table->string('code', 191)->nullable();
			$table->enum('app', array('ios', 'android'));
			$table->enum('status', array('active', 'not_active'));
			$table->string('password', 191);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}