<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('Employees', function(Blueprint $table) {
			$table->increments('employee_id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_person_party_id')->unsigned();
			$table->date('joining_date');
			$table->integer('type');
			$table->integer('designation_id');
			$table->integer('organization_party_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Employees');
	}
}