<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('Insurances', function(Blueprint $table) {
			$table->increments('insurance_id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('provider_name', 300);
			$table->date('start_date');
			$table->date('end_date');
			$table->decimal('premium_amount', 15,2);
			$table->string('type', 50);
		});
	}

	public function down()
	{
		Schema::drop('Insurances');
	}
}