<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Parties', function(Blueprint $table) {
			$table->foreign('location_id')->references('location_id')->on('Locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Locations', function(Blueprint $table) {
			$table->foreign('location_states_id')->references('location_states_id')->on('Location_States')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Persons', function(Blueprint $table) {
			$table->foreign('party_id')->references('party_id')->on('Parties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Persons', function(Blueprint $table) {
			$table->foreign('insurance_id')->references('insurance_id')->on('Insurances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Person_Family_Relations', function(Blueprint $table) {
			$table->foreign('person_party_id')->references('party_id')->on('Persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Person_Family_Relations', function(Blueprint $table) {
			$table->foreign('family_member_party_id')->references('party_id')->on('Persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Organizations', function(Blueprint $table) {
			$table->foreign('organization_party_id')->references('party_id')->on('Parties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employees', function(Blueprint $table) {
			$table->foreign('employee_person_party_id')->references('party_id')->on('Persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employees', function(Blueprint $table) {
			$table->foreign('organization_party_id')->references('party_id')->on('Parties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employee_details', function(Blueprint $table) {
			$table->foreign('employee_person_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employee_managers', function(Blueprint $table) {
			$table->foreign('employee_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employee_managers', function(Blueprint $table) {
			$table->foreign('manager_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employee_projects', function(Blueprint $table) {
			$table->foreign('employee_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employee_projects', function(Blueprint $table) {
			$table->foreign('project_id')->references('project_id')->on('Projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Organization_projects', function(Blueprint $table) {
			$table->foreign('organization_party_id')->references('organization_party_id')->on('Organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Organization_projects', function(Blueprint $table) {
			$table->foreign('project_id')->references('project_id')->on('Projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->foreign('employee_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->foreign('project_id')->references('project_id')->on('Projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->foreign('client_manager_party_id')->references('employee_person_party_id')->on('Employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('party_id')->references('party_id')->on('Parties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Parties', function(Blueprint $table) {
			$table->dropForeign('Parties_location_id_foreign');
		});
		Schema::table('Locations', function(Blueprint $table) {
			$table->dropForeign('Locations_location_states_id_foreign');
		});
		Schema::table('Persons', function(Blueprint $table) {
			$table->dropForeign('Persons_party_id_foreign');
		});
		Schema::table('Persons', function(Blueprint $table) {
			$table->dropForeign('Persons_insurance_id_foreign');
		});
		Schema::table('Person_Family_Relations', function(Blueprint $table) {
			$table->dropForeign('Person_Family_Relations_person_party_id_foreign');
		});
		Schema::table('Person_Family_Relations', function(Blueprint $table) {
			$table->dropForeign('Person_Family_Relations_family_member_party_id_foreign');
		});
		Schema::table('Organizations', function(Blueprint $table) {
			$table->dropForeign('Organizations_organization_party_id_foreign');
		});
		Schema::table('Employees', function(Blueprint $table) {
			$table->dropForeign('Employees_employee_person_party_id_foreign');
		});
		Schema::table('Employees', function(Blueprint $table) {
			$table->dropForeign('Employees_organization_party_id_foreign');
		});
		Schema::table('Employee_details', function(Blueprint $table) {
			$table->dropForeign('Employee_details_employee_person_party_id_foreign');
		});
		Schema::table('Employee_managers', function(Blueprint $table) {
			$table->dropForeign('Employee_managers_employee_party_id_foreign');
		});
		Schema::table('Employee_managers', function(Blueprint $table) {
			$table->dropForeign('Employee_managers_manager_party_id_foreign');
		});
		Schema::table('Employee_projects', function(Blueprint $table) {
			$table->dropForeign('Employee_projects_employee_party_id_foreign');
		});
		Schema::table('Employee_projects', function(Blueprint $table) {
			$table->dropForeign('Employee_projects_project_id_foreign');
		});
		Schema::table('Organization_projects', function(Blueprint $table) {
			$table->dropForeign('Organization_projects_organization_party_id_foreign');
		});
		Schema::table('Organization_projects', function(Blueprint $table) {
			$table->dropForeign('Organization_projects_project_id_foreign');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->dropForeign('Work_hours_employee_party_id_foreign');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->dropForeign('Work_hours_project_id_foreign');
		});
		Schema::table('Work_hours', function(Blueprint $table) {
			$table->dropForeign('Work_hours_client_manager_party_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_role_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_party_id_foreign');
		});
	}
}