<?php

namespace EventLocation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventLocation extends Model 
{

    protected $table = 'EventLocation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function times()
    {
        return $this->belongsToMany('Time');
    }

    public function event()
    {
        return $this->belongsTo('Event');
    }

    public function location()
    {
        return $this->belongsTo('Location', 'location_id');
    }

}