<?php

namespace Time;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Time extends Model 
{

    protected $table = 'Time';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function event()
    {
        return $this->belongsTo('Event', 'id');
    }

    public function locations()
    {
        return $this->belongsToMany('EventLocation', 'id');
    }

}