<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->string('service_type', 191);
			$table->integer('parent_id')->default('0');
			$table->string('service_charge', 191);
			$table->string('latitude', 191);
			$table->string('longitude', 191);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}