<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned();
			$table->string('entity_type')->default('0');
			$table->text('post_text');
			$table->string('post_media')->nullable();
			$table->integer('share');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}