<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bill extends Eloquent {

	protected $table = 'bills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer');
	}

	public function products()
	{
		return $this->belongsToMany('Product', 'bill_products')->withTimestamps();
	}

}