<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('photo');
			$table->string('rank');
			$table->string('email')->unique();
			$table->string('twitter');
			$table->string('linkedin');
			$table->text('resume');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}