<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanydirectorsTable extends Migration {

	public function up()
	{
		Schema::create('companydirectors', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('companyID')->unsigned()->default('NULL');
			$table->string('name', 255)->default('NULL');
			$table->string('documentPhoto', 255)->unique()->nullable()->default('NULL');
			$table->string('taxId', 255)->unique()->nullable()->default('NULL');
			$table->longText('address')->unique()->default('NULL');
			$table->string('city', 255)->default('NULL');
			$table->string('zip_code', 255);
			$table->integer('countryID')->unsigned()->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companydirectors');
	}
}