<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyshareholdersTable extends Migration {

	public function up()
	{
		Schema::create('companyshareholders', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->integer('companyID')->unsigned()->default('NULL');
			$table->string('name', 255)->unique()->default('NULL');
			$table->string('documentPhoto', 255)->nullable()->default('NULL');
			$table->string('taxID', 255)->unique()->nullable()->default('NULL');
			$table->longText('address')->unique()->default('NULL');
			$table->string('city', 255)->default('NULL');
			$table->string('zip_code', 255)->default('NULL');
			$table->integer('countryID');
			$table->integer('numberOfShare')->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companyshareholders');
	}
}