<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShowroomsTable extends Migration {

	public function up()
	{
		Schema::create('showrooms', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name', 255);
			$table->string('image', 255);
			$table->text('description');
			$table->time('open_hour');
			$table->time('close_hour');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('showrooms');
	}
}