<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentTable extends Migration {

	public function up()
	{
		Schema::create('content', function(Blueprint $table) {
			$table->increments('id');
			$table->string('content_title', 256);
			$table->string('content_slug', 256)->unique();
			$table->longText('content_text');
			$table->tinyInteger('type')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('content');
	}
}