<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElectionsTable extends Migration {

	public function up()
	{
		Schema::create('elections', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->integer('election_type');
			$table->datetime('start_date_time');
			$table->datetime('end_date_time');
			$table->string('email', 300);
			$table->string('phone', 100);
			$table->string('description', 500);
			$table->text('address');
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('elections');
	}
}