<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function state()
	{
		return $this->hasMany('Model\States', 'state_id');
	}

}