<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Result extends Eloquent {

	protected $table = 'results';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('election_polling_area_id', 'first_preference_voting', 'second_preference_voting', 'third_preference_voting');

	public function polling_area()
	{
		return $this->belongsTo('Model\ElectionPollingArea', 'polling_area_id');
	}

}