<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VoterFile extends Eloquent {

	protected $table = 'voter_files';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('polling_area_id', 'name');

	public function file()
	{
		return $this->belongsTo('Model\PollingArea', 'polling_area_id');
	}

}