<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 128);
			$table->string('sku');
			$table->text('description');
			$table->string('slug', 128)->nullable();
			$table->integer('base_price');
			$table->integer('sale_price')->nullable();
			$table->string('meta_description', 128)->nullable();
			$table->string('meta_title', 128)->nullable();
			$table->text('meta_keywords')->nullable();
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}