<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWinchReservationsTable extends Migration {

	public function up()
	{
		Schema::create('winch_reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('address_ar')->nullable();
			$table->string('address_en')->nullable();
			$table->string('phone');
			$table->string('from')->nullable();
			$table->string('to')->nullable();
			$table->enum('status', array('waiting', 'paid', 'reserved', 'confirmed'));
			$table->bigInteger('winch_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('winch_reservations');
	}
}