<?php

namespace App\Models;

class RentalOffice extends Eloquent {

	protected $table = 'rental_offices';
	public $timestamps = true;
	protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'record_number', 'active', 'availablity', 'day_off_id', 'country_id', 'timestamps');

	public function reviews()
	{
		return $this->morphToMany('App\Models\User', 'reviewable');
	}

	public function favourites()
	{
		return $this->morphToMany('App\Models\User', 'favouriable');
	}

	public function work_time()
	{
		return $this->morphOne('App\Models\WorkTime', 'workable');
	}

	public function contact()
	{
		return $this->morphOne('App\Models\Contact', 'contactable');
	}

	public function rental_cars()
	{
		return $this->hasMany('App\Models\RentalCars');
	}

	public function policies()
	{
		return $this->morphMany('App\Models\Policy', 'policiable');
	}

	public function categories()
	{
		return $this->morphToMany('App\Models\Category', 'categorizable');
	}

	public function day_offs()
	{
		return $this->hasMany('App\Models\DayOffs');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

}