<?php

namespace App\Models;

class Winch extends Eloquent {

	protected $table = 'winches';
	public $timestamps = true;
	protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'logo', 'record_number', 'active', 'availablity', 'status', 'place_type', 'type', 'country_id');

	public function contact()
	{
		return $this->morphOne('App\Models\Contact', 'contactable');
	}

	public function reviews()
	{
		return $this->morphToMany('App\Models\User', 'reviewable');
	}

	public function favourites()
	{
		return $this->morphToMany('App\Models\User', 'favouriable');
	}

	public function services()
	{
		return $this->morphMany('App\Models\Service', 'servable');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

}