<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgenciesTable extends Migration {

	public function up()
	{
		Schema::create('agencies', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->string('record_number');
			$table->string('logo')->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('brand_id')->unsigned();
			$table->string('year_founded');
			$table->bigInteger('day_off_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('agencies');
	}
}