<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryAddressesTable extends Migration {

	public function up()
	{
		Schema::create('delivery_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('house_number');
			$table->string('postcode');
			$table->string('city');
			$table->string('company_name')->nullable();
			$table->text('notes');
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('delivery_addresses');
	}
}