<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('menu_sections', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('menu_section_id')->references('id')->on('menu_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_way_id')->references('id')->on('payment_ways')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturant_tables', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('resturant_regions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturant_tables', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturants', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturants', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('resturant_table_id')->references('id')->on('resturant_tables')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('resturant_regions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('resturant_section_id')->references('id')->on('resturant_sections')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturant_sections', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_shift', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_shift', function(Blueprint $table) {
			$table->foreign('shift_id')->references('id')->on('shifts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('resturant_customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_performances', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_performances', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_ways', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('payment_way_id')->references('id')->on('payment_ways')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('delivery_reviews', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('delivery_reviews', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('delivery_routes', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('deliveries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_invoices', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_invoices', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_menu_item', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_menu_item', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('meal_attributes', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('meal_attributes', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_resturant', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_resturant', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('resturants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('delivery_addresses', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('menu_sections', function(Blueprint $table) {
			$table->dropForeign('menu_sections_resturant_id_foreign');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_menu_section_id_foreign');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_resturant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_resturant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_way_id_foreign');
		});
		Schema::table('resturant_tables', function(Blueprint $table) {
			$table->dropForeign('resturant_tables_region_id_foreign');
		});
		Schema::table('resturant_tables', function(Blueprint $table) {
			$table->dropForeign('resturant_tables_resturant_id_foreign');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->dropForeign('order_item_menu_item_id_foreign');
		});
		Schema::table('order_item', function(Blueprint $table) {
			$table->dropForeign('order_item_order_id_foreign');
		});
		Schema::table('resturants', function(Blueprint $table) {
			$table->dropForeign('resturants_country_id_foreign');
		});
		Schema::table('resturants', function(Blueprint $table) {
			$table->dropForeign('resturants_city_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_customer_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_resturant_table_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_region_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_resturant_section_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_resturant_id_foreign');
		});
		Schema::table('resturant_sections', function(Blueprint $table) {
			$table->dropForeign('resturant_sections_resturant_id_foreign');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->dropForeign('shifts_resturant_id_foreign');
		});
		Schema::table('employee_shift', function(Blueprint $table) {
			$table->dropForeign('employee_shift_employee_id_foreign');
		});
		Schema::table('employee_shift', function(Blueprint $table) {
			$table->dropForeign('employee_shift_shift_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_resturant_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_employee_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_resturant_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_resturant_customer_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_resturant_id_foreign');
		});
		Schema::table('employee_performances', function(Blueprint $table) {
			$table->dropForeign('employee_performances_employee_id_foreign');
		});
		Schema::table('employee_performances', function(Blueprint $table) {
			$table->dropForeign('employee_performances_resturant_id_foreign');
		});
		Schema::table('payment_ways', function(Blueprint $table) {
			$table->dropForeign('payment_ways_resturant_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_payment_way_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_customer_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_order_id_foreign');
		});
		Schema::table('payment_transactions', function(Blueprint $table) {
			$table->dropForeign('payment_transactions_resturant_id_foreign');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->dropForeign('promotions_menu_item_id_foreign');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->dropForeign('promotions_resturant_id_foreign');
		});
		Schema::table('delivery_reviews', function(Blueprint $table) {
			$table->dropForeign('delivery_reviews_customer_id_foreign');
		});
		Schema::table('delivery_reviews', function(Blueprint $table) {
			$table->dropForeign('delivery_reviews_order_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_employee_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_order_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_resturant_id_foreign');
		});
		Schema::table('delivery_routes', function(Blueprint $table) {
			$table->dropForeign('delivery_routes_delivery_id_foreign');
		});
		Schema::table('order_invoices', function(Blueprint $table) {
			$table->dropForeign('order_invoices_order_id_foreign');
		});
		Schema::table('order_invoices', function(Blueprint $table) {
			$table->dropForeign('order_invoices_resturant_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_customer_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_resturant_id_foreign');
		});
		Schema::table('cart_menu_item', function(Blueprint $table) {
			$table->dropForeign('cart_menu_item_cart_id_foreign');
		});
		Schema::table('cart_menu_item', function(Blueprint $table) {
			$table->dropForeign('cart_menu_item_menu_item_id_foreign');
		});
		Schema::table('meal_attributes', function(Blueprint $table) {
			$table->dropForeign('meal_attributes_resturant_id_foreign');
		});
		Schema::table('meal_attributes', function(Blueprint $table) {
			$table->dropForeign('meal_attributes_menu_item_id_foreign');
		});
		Schema::table('customer_resturant', function(Blueprint $table) {
			$table->dropForeign('customer_resturant_customer_id_foreign');
		});
		Schema::table('customer_resturant', function(Blueprint $table) {
			$table->dropForeign('customer_resturant_resturant_id_foreign');
		});
		Schema::table('delivery_addresses', function(Blueprint $table) {
			$table->dropForeign('delivery_addresses_order_id_foreign');
		});
	}
}