<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCriteriaRatingsTable extends Migration {

	public function up()
	{
		Schema::create('criteria_ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('criteria_value_id')->unsigned();
			$table->integer('application_id')->unsigned();
			$table->integer('user_id');
			$table->integer('points');
			$table->longText('comment')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('criteria_ratings');
	}
}