<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicantsTable extends Migration {

	public function up()
	{
		Schema::create('applicants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('psu_id', 9)->unique();
			$table->string('first')->nullable();
			$table->string('last')->nullable();
			$table->string('email')->nullable();
			$table->string('home_phone')->nullable();
			$table->string('dob')->nullable();
			$table->string('gender')->nullable();
			$table->string('ethnicity')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('applicants');
	}
}