<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('application_files', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('applicant_university', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('applicant_university', function(Blueprint $table) {
			$table->foreign('university_id')->references('id')->on('universities')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('rubrics', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('programs')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('criteria', function(Blueprint $table) {
			$table->foreign('rubric_id')->references('id')->on('rubrics')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('criteria_values', function(Blueprint $table) {
			$table->foreign('criteria_id')->references('id')->on('criteria')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('criteria_ratings', function(Blueprint $table) {
			$table->foreign('criteria_value_id')->references('id')->on('criteria_values')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('criteria_ratings', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('applicant_employers', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('no action')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_applicant_id_foreign');
		});
		Schema::table('application_files', function(Blueprint $table) {
			$table->dropForeign('application_files_application_id_foreign');
		});
		Schema::table('applicant_university', function(Blueprint $table) {
			$table->dropForeign('applicant_university_applicant_id_foreign');
		});
		Schema::table('applicant_university', function(Blueprint $table) {
			$table->dropForeign('applicant_university_university_id_foreign');
		});
		Schema::table('rubrics', function(Blueprint $table) {
			$table->dropForeign('rubrics_program_id_foreign');
		});
		Schema::table('criteria', function(Blueprint $table) {
			$table->dropForeign('criteria_rubric_id_foreign');
		});
		Schema::table('criteria_values', function(Blueprint $table) {
			$table->dropForeign('criteria_values_criteria_id_foreign');
		});
		Schema::table('criteria_ratings', function(Blueprint $table) {
			$table->dropForeign('criteria_ratings_criteria_value_id_foreign');
		});
		Schema::table('criteria_ratings', function(Blueprint $table) {
			$table->dropForeign('criteria_ratings_application_id_foreign');
		});
		Schema::table('applicant_employers', function(Blueprint $table) {
			$table->dropForeign('applicant_employers_applicant_id_foreign');
		});
	}
}