<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('school_id');
			$table->string('surname', 255);
			$table->string('first_name', 255);
			$table->string('middle_name', 255);
			$table->string('gender', 1);
			$table->date('dob');
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}