<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_subscription_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_type_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_payment_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_customer_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_order_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_subscription_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_payment_type_id_foreign');
		});
		Schema::table('payment_statistics', function(Blueprint $table) {
			$table->dropForeign('payment_statistics_product_id_foreign');
		});
	}
}