<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Store extends Model 
{

    protected $table = 'store';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'capacity', 'current_capacity', 'status', 'location_id', 'store_category_id');

    public function location()
    {
        return $this->hasOne('Location');
    }

}