<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTable extends Migration {

	public function up()
	{
		Schema::create('store', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->float('capacity');
			$table->float('current_capacity')->nullable();
			$table->boolean('status')->nullable();
			$table->bigInteger('location_id')->unsigned();
			$table->bigInteger('store_category_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('store');
	}
}