<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('store', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store', function(Blueprint $table) {
			$table->foreign('store_category_id')->references('id')->on('store_category')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('product_category_id')->references('id')->on('product_category')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('distribution_center', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('distribution_center', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sell_order', function(Blueprint $table) {
			$table->foreign('distribution_center_id')->references('id')->on('distribution_center')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('sell_bill', function(Blueprint $table) {
			$table->foreign('sell_order_id')->references('id')->on('sell_order')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_product', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('store_user', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('sell_order_item', function(Blueprint $table) {
			$table->foreign('sell_order_id')->references('id')->on('sell_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sell_order_item', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sell_bill_item', function(Blueprint $table) {
			$table->foreign('sell_bill_id')->references('id')->on('sell_bill')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sell_bill_item', function(Blueprint $table) {
			$table->foreign('sell_order_item_id')->references('id')->on('sell_order_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_out', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_out', function(Blueprint $table) {
			$table->foreign('sell_bill_item_id')->references('id')->on('sell_bill_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_order_item', function(Blueprint $table) {
			$table->foreign('fill_order_id')->references('id')->on('fill_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_order_item', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_bill', function(Blueprint $table) {
			$table->foreign('fill_order_id')->references('id')->on('fill_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_bill_item', function(Blueprint $table) {
			$table->foreign('fill_bill_id')->references('id')->on('fill_bill')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fill_bill_item', function(Blueprint $table) {
			$table->foreign('fill_order_item_id')->references('id')->on('fill_order_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_in', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_in', function(Blueprint $table) {
			$table->foreign('fill_bill_item_id')->references('id')->on('fill_bill_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('location', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('store', function(Blueprint $table) {
			$table->dropForeign('store_location_id_foreign');
		});
		Schema::table('store', function(Blueprint $table) {
			$table->dropForeign('store_store_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_product_category_id_foreign');
		});
		Schema::table('distribution_center', function(Blueprint $table) {
			$table->dropForeign('distribution_center_user_id_foreign');
		});
		Schema::table('distribution_center', function(Blueprint $table) {
			$table->dropForeign('distribution_center_location_id_foreign');
		});
		Schema::table('sell_order', function(Blueprint $table) {
			$table->dropForeign('sell_order_distribution_center_id_foreign');
		});
		Schema::table('sell_bill', function(Blueprint $table) {
			$table->dropForeign('sell_bill_sell_order_id_foreign');
		});
		Schema::table('store_product', function(Blueprint $table) {
			$table->dropForeign('store_product_product_id_foreign');
		});
		Schema::table('store_product', function(Blueprint $table) {
			$table->dropForeign('store_product_store_id_foreign');
		});
		Schema::table('store_user', function(Blueprint $table) {
			$table->dropForeign('store_user_user_id_foreign');
		});
		Schema::table('store_user', function(Blueprint $table) {
			$table->dropForeign('store_user_store_id_foreign');
		});
		Schema::table('sell_order_item', function(Blueprint $table) {
			$table->dropForeign('sell_order_item_sell_order_id_foreign');
		});
		Schema::table('sell_order_item', function(Blueprint $table) {
			$table->dropForeign('sell_order_item_product_id_foreign');
		});
		Schema::table('sell_bill_item', function(Blueprint $table) {
			$table->dropForeign('sell_bill_item_sell_bill_id_foreign');
		});
		Schema::table('sell_bill_item', function(Blueprint $table) {
			$table->dropForeign('sell_bill_item_sell_order_item_id_foreign');
		});
		Schema::table('book_out', function(Blueprint $table) {
			$table->dropForeign('book_out_store_id_foreign');
		});
		Schema::table('book_out', function(Blueprint $table) {
			$table->dropForeign('book_out_sell_bill_item_id_foreign');
		});
		Schema::table('fill_order', function(Blueprint $table) {
			$table->dropForeign('fill_order_user_id_foreign');
		});
		Schema::table('fill_order_item', function(Blueprint $table) {
			$table->dropForeign('fill_order_item_fill_order_id_foreign');
		});
		Schema::table('fill_order_item', function(Blueprint $table) {
			$table->dropForeign('fill_order_item_product_id_foreign');
		});
		Schema::table('fill_bill', function(Blueprint $table) {
			$table->dropForeign('fill_bill_fill_order_id_foreign');
		});
		Schema::table('fill_bill_item', function(Blueprint $table) {
			$table->dropForeign('fill_bill_item_fill_bill_id_foreign');
		});
		Schema::table('fill_bill_item', function(Blueprint $table) {
			$table->dropForeign('fill_bill_item_fill_order_item_id_foreign');
		});
		Schema::table('book_in', function(Blueprint $table) {
			$table->dropForeign('book_in_store_id_foreign');
		});
		Schema::table('book_in', function(Blueprint $table) {
			$table->dropForeign('book_in_fill_bill_item_id_foreign');
		});
		Schema::table('location', function(Blueprint $table) {
			$table->dropForeign('location_state_id_foreign');
		});
	}
}