<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewardsTable extends Migration {

	public function up()
	{
		Schema::create('rewards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('amount');
			$table->text('note');
			$table->enum('status', array('paid', 'pending', 'decline'));
			$table->integer('employee_id')->unsigned();
			$table->integer('moderator_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('rewards');
	}
}