<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Teacher extends Model 
{

    protected $table = 'teachers';
    public $timestamps = true;

    public function categories()
    {
        return $this->hasOne('App/Models\Category');
    }

    public function cities()
    {
        return $this->hasOne('App/Models\City');
    }

    public function specializations()
    {
        return $this->belongsToMany('App/Models\Specialization');
    }

    public function levels()
    {
        return $this->belongsToMany('App/Models\Level');
    }

}