<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('plan_user', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_activations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('plan_user', function(Blueprint $table) {
			$table->dropForeign('plan_user_plan_id_foreign');
		});
		Schema::table('plan_user', function(Blueprint $table) {
			$table->dropForeign('plan_user_user_id_foreign');
		});
		Schema::table('user_activations', function(Blueprint $table) {
			$table->dropForeign('user_activations_user_id_foreign');
		});
	}
}