<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mnt_properties', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('mnt_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mnt_orders', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('mnt_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mnt_orders', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mnt_cancelled_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('mnt_orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mnt_order_histories', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('mnt_orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('mnt_suppliers', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('mnt_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mnt_items', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('mnt_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('order_property', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('mnt_orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('order_property', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('order_property')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('item_supplier', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('mnt_items')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('item_supplier', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('mnt_suppliers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('supplier_items', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('item_supplier')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('supplier_items', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('mnt_items')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('checkups', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('mnt_orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('checkup_parts', function(Blueprint $table) {
			$table->foreign('checkup_id')->references('id')->on('checkups')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('mnt_orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('mnt_suppliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('mnt_items')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('type_validations', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('mnt_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_department_id_foreign');
		});
		Schema::table('mnt_properties', function(Blueprint $table) {
			$table->dropForeign('mnt_properties_type_id_foreign');
		});
		Schema::table('mnt_orders', function(Blueprint $table) {
			$table->dropForeign('mnt_orders_type_id_foreign');
		});
		Schema::table('mnt_orders', function(Blueprint $table) {
			$table->dropForeign('mnt_orders_employee_id_foreign');
		});
		Schema::table('mnt_cancelled_orders', function(Blueprint $table) {
			$table->dropForeign('mnt_cancelled_orders_order_id_foreign');
		});
		Schema::table('mnt_order_histories', function(Blueprint $table) {
			$table->dropForeign('mnt_order_histories_order_id_foreign');
		});
		Schema::table('mnt_suppliers', function(Blueprint $table) {
			$table->dropForeign('mnt_suppliers_type_id_foreign');
		});
		Schema::table('mnt_items', function(Blueprint $table) {
			$table->dropForeign('mnt_items_type_id_foreign');
		});
		Schema::table('order_property', function(Blueprint $table) {
			$table->dropForeign('order_property_order_id_foreign');
		});
		Schema::table('order_property', function(Blueprint $table) {
			$table->dropForeign('order_property_property_id_foreign');
		});
		Schema::table('item_supplier', function(Blueprint $table) {
			$table->dropForeign('item_supplier_item_id_foreign');
		});
		Schema::table('item_supplier', function(Blueprint $table) {
			$table->dropForeign('item_supplier_supplier_id_foreign');
		});
		Schema::table('supplier_items', function(Blueprint $table) {
			$table->dropForeign('supplier_items_supplier_id_foreign');
		});
		Schema::table('supplier_items', function(Blueprint $table) {
			$table->dropForeign('supplier_items_item_id_foreign');
		});
		Schema::table('checkups', function(Blueprint $table) {
			$table->dropForeign('checkups_order_id_foreign');
		});
		Schema::table('checkup_parts', function(Blueprint $table) {
			$table->dropForeign('checkup_parts_checkup_id_foreign');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->dropForeign('item_order_order_id_foreign');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->dropForeign('item_order_supplier_id_foreign');
		});
		Schema::table('item_order', function(Blueprint $table) {
			$table->dropForeign('item_order_item_id_foreign');
		});
		Schema::table('type_validations', function(Blueprint $table) {
			$table->dropForeign('type_validations_type_id_foreign');
		});
	}
}