<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('restaurant_id')->unsigned();
			$table->decimal('total_price');
			$table->integer('client_id')->unsigned();
			$table->decimal('delivery_price');
			$table->decimal('price');
			$table->string('address');
			$table->enum('status', array(''pending'', ''accepted'', ''rejected'', ''delivered'', ''canceled''));
			$table->decimal('commission');
			$table->decimal('net_price');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}