<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_course', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_course', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_subject', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_subject', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_subject_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_user_id_foreign');
		});
		Schema::table('user_course', function(Blueprint $table) {
			$table->dropForeign('user_course_user_id_foreign');
		});
		Schema::table('user_course', function(Blueprint $table) {
			$table->dropForeign('user_course_course_id_foreign');
		});
		Schema::table('course_subject', function(Blueprint $table) {
			$table->dropForeign('course_subject_course_id_foreign');
		});
		Schema::table('course_subject', function(Blueprint $table) {
			$table->dropForeign('course_subject_subject_id_foreign');
		});
		Schema::table('user_subject', function(Blueprint $table) {
			$table->dropForeign('user_subject_user_id_foreign');
		});
		Schema::table('user_subject', function(Blueprint $table) {
			$table->dropForeign('user_subject_subject_id_foreign');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->dropForeign('user_task_user_id_foreign');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->dropForeign('user_task_task_id_foreign');
		});
	}
}