<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionMedicationTable extends Migration {

	public function up()
	{
		Schema::create('prescription_medication', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('prescription_id')->unsigned();
			$table->string('tablet_name', 299)->nullable();
			$table->string('tablet_quantity', 299)->nullable();
			$table->integer('supply_days')->nullable();
			$table->tinyInteger('substitution')->default('1');
			$table->text('sig');
		});
	}

	public function down()
	{
		Schema::drop('prescription_medication');
	}
}