<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->integer('role_id')->unsigned();
			$table->bigIncrements('id');
			$table->string('first_name', 299);
			$table->string('last_name', 299)->nullable();
			$table->string('email', 299);
			$table->date('dob')->nullable();
			$table->string('gender', 10)->nullable();
			$table->string('password', 299);
			$table->tinyInteger('status')->default('1');
			$table->string('stripe_id', 299)->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->text('profile_pic')->nullable();
			$table->tinyInteger('subscription_status')->default('1');
			$table->timestamps();
			$table->tinyInteger('initial_status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}