<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationTable extends Migration {

	public function up()
	{
		Schema::create('operation', function(Blueprint $table) {
			$table->increments('id');
			$table->float('amount')->default('0');
			$table->tinyInteger('polarity')->unsigned()->default('1');
			$table->integer('devise_id')->unsigned()->default('0');
			$table->integer('category_id')->unsigned()->default('0');
			$table->string('label')->nullable();
			$table->integer('banking_account_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->datetime('datetime');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operation');
	}
}