<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_banking_account', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_banking_account', function(Blueprint $table) {
			$table->foreign('banking_account_id')->references('id')->on('banking_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->foreign('banking_account_id')->references('id')->on('banking_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('icon_id')->references('id')->on('icon')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('balance', function(Blueprint $table) {
			$table->foreign('banking_account_id')->references('id')->on('banking_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invitation', function(Blueprint $table) {
			$table->foreign('banking_account_id')->references('id')->on('user_banking_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_banking_account', function(Blueprint $table) {
			$table->dropForeign('user_banking_account_user_id_foreign');
		});
		Schema::table('user_banking_account', function(Blueprint $table) {
			$table->dropForeign('user_banking_account_banking_account_id_foreign');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->dropForeign('operation_category_id_foreign');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->dropForeign('operation_banking_account_id_foreign');
		});
		Schema::table('operation', function(Blueprint $table) {
			$table->dropForeign('operation_user_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_icon_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_user_id_foreign');
		});
		Schema::table('balance', function(Blueprint $table) {
			$table->dropForeign('balance_banking_account_id_foreign');
		});
		Schema::table('invitation', function(Blueprint $table) {
			$table->dropForeign('invitation_banking_account_id_foreign');
		});
	}
}