<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Probleme extends Model 
{

    protected $table = 'problemes';
    public $timestamps = true;
    protected $fillable = array('type', 'id_saver', 'id_validator', 'id_prestataire', 'id_contrat', 'description');
    protected $visible = array('type', 'id_saver', 'id_validator', 'id_prestataire', 'id_contrat', 'description');

    public function saver()
    {
        return $this->belongsTo('User', 'id_saver');
    }

    public function contrat()
    {
        return $this->belongsTo('App\Contrat', 'id_contrat');
    }

    public function prestataire()
    {
        return $this->belongsTo('App\User', 'id_prestataire');
    }

    public function depenses()
    {
        return $this->hasMany('App\Depenses', 'id_probleme');
    }

    public function versements_locataire()
    {
        return $this->hasMany('App\Versement_locataire', 'id_probleme');
    }

}