<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuildingTable extends Migration {

	public function up()
	{
		Schema::create('building', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('libelle', 255)->nullable();
			$table->string('quartier', 255);
			$table->string('adresse', 255)->nullable();
			$table->text('description')->nullable();
			$table->smallInteger('nbre_pieces')->default('1');
			$table->smallInteger('nbre_chambres')->default('0');
			$table->smallInteger('nbre_salons')->default('0');
			$table->smallInteger('nbre_douches')->default('0');
			$table->smallInteger('nbre_cuisines')->default('0');
			$table->boolean('parking')->default(0);
			$table->boolean('barriere')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('building');
	}
}