<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProblemesTable extends Migration {

	public function up()
	{
		Schema::create('problemes', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('entretien', 'securite'));
			$table->integer('id_saver')->unsigned();
			$table->integer('id_validator')->unsigned()->nullable();
			$table->timestamps();
			$table->integer('id_prestataire')->unsigned()->nullable();
			$table->integer('id_contrat')->unsigned();
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('problemes');
	}
}