<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('area');
			$table->string('block_no');
			$table->string('street_no');
			$table->string('building_type');
			$table->string('house_no');
			$table->string('building_no');
			$table->string('floor_no');
			$table->string('flat_no');
			$table->string('landmark');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}