<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->integer('club_id')->unsigned();
			$table->smallInteger('number_of_participents');
			$table->datetime('booking_date');
			$table->enum('booking_status', array(''pending'', ''confirmed'', ''refused'', ''need_response''));
			$table->enum('booking_for', array(''events'', ''programs'', ''clubs''));
			$table->text('comment');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}