<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersInterestedEventsTable extends Migration {

	public function up()
	{
		Schema::create('users_interested_events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('event_id')->unsigned();
			$table->enum('action', array('not_going', 'going', 'interested'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_interested_events');
	}
}