<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsMenusItemsTable extends Migration {

	public function up()
	{
		Schema::create('clubs_menus_items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('image')->nullable();
			$table->string('description')->nullable();
			$table->text('ingredients')->nullable();
			$table->bigInteger('club_id')->unsigned();
			$table->bigInteger('clubs_menus_categries_items_id')->unsigned()->index();
			$table->boolean('available_for_customers')->default(1);
			$table->boolean('has_happy_hour_discount')->default(0);
			$table->boolean('has_member_discount')->default(0);
			$table->boolean('is_vegan')->default(0);
			$table->boolean('is_gluten_free')->default(0);
			$table->boolean('is_spicy')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clubs_menus_items');
	}
}